 ; Ŀ
 ;   Ac - Copy attributes from one block into others.                      
 ;   Includes: Acc - copy attributes from a block to an ss.                
 ;             Ack - copy atts from one block to another, erase the first. 
 ;             Sac - copy attributes from an ss to another ss.             
 ;   Copyright 1995, 2002, 2004 - 2007 by Rocket Software Ltd.             
 ;   Copies attributes in order, assumes some similarity between blocks.   
 ;   The computer is the steam engine of the 21st Century.                 
 ; 

 ; Ŀ
 ;   Atlist - suck attribute values from a block into a list.              
 ; 
 (DEFUN ATLIST (enam / entt tagg taglst)
  (while (and (setq entt (entget (setq enam (entnext enam))))
              (/= (cdr (assoc 0 entt)) "SEQEND"))
         (setq tagg (cdr (assoc 1 entt)))
         (setq taglst (append taglst (list tagg))))
 taglst)
 ; Ŀ
 ;   Atlist end.                                                           
 ; 

 ; Ŀ
 ;   Silt - put attribute values from a list into a block.                 
 ; 
 (DEFUN SILT (enam taglst / esav entt tag)
  (setq esav enam)
  (while (and (setq entt (entget (setq enam (entnext enam))))
              (/= (cdr (assoc 0 entt)) "SEQEND")
              (setq tag (car taglst)))
         (setq taglst (cdr taglst))
         (entmod (subst (cons 1 tag) (assoc 1 entt) entt)))
  (entupd esav)
 (princ))
 ; Ŀ
 ;   Silt end.                                                             
 ; 

 ; Ŀ
 ;   Spit - returns the insertion point of the text entity whose data was  
 ;   passed as its sole argument.  Note that this is not necessarily the   
 ;   same as the 10 association code.                                      
 ; 
 (DEFUN SPIT (entt / xjust yjust)
  (setq xjust (cdr (assoc 72 entt)))
  (if (= (cdr (assoc 0 entt)) "ATTDEF")
      (setq yjust (cdr (assoc 74 entt)))
      (setq yjust (cdr (assoc 73 entt))))
  (if (or (/= xjust 0) (/= yjust 0))
      (cdr (assoc 11 entt))
      (cdr (assoc 10 entt))))
 ; Ŀ
 ;   Spit end.                                                             
 ; 

 ; Ŀ
 ;   V - show the contents of a block on the screen menu.                  
 ; 
 (DEFUN V (enam / entt level enam tagg)
  (if (and (setq entt (entget enam))
           (assoc 66 entt))
      (progn
           (grtext 14 " ")
           (grtext 15 " ")
           (setq level 16)
           (while (and (setq entt (entget (setq enam (entnext enam))))
                       (/= (cdr (assoc 0 entt)) "SEQEND"))
                  (setq tagg (cdr (assoc 1 entt)))
                  (if (= tagg "") (setq tagg "..."))
                  (grtext level tagg)
                  (setq level (1+ level)))
           (grtext level " ")
           (setq level (1+ level))
           (grtext level " "))
      (progn
           (grtext)))
 (princ))
 ; Ŀ
 ;   V end.                                                                
 ; 

 ; Ŀ
 ;   Subroutine Vtol: returns a list of enames ordered entity position.    
 ;   Arguments: Ss, a selection set of entities to order.                  
 ;              Dir, a direction - if this is either "X" or "Y" then the   
 ;                   entities are assumed to be arrayed in that direction, 
 ;                   if anything else then the routine uses the direction  
 ;                   in which they are most spread out.                    
 ;              Insa, if T and the entity is text or an attribute then     
 ;                    sort based on the insertion point rather than the    
 ;                    ten point.                                           
 ;                                                                         
 ;   This is the latest version: 2006.10.05, which sorts text by           
 ;   insertion point rather than ten point and in which setting the        
 ;   direction to nil doesn't cause a crash.                               
 ;   Also it works with attdefs as well as text.                           
 ;   It should replace all other uses of Vtol and Stol.                    
 ;                                                                         
 ;   Revamped 2009.07.28 to use Apply rather than Eval Cons 'Max List etc. 
 ;   This is less elegant but removes the 256 entity limitation.           
 ;   Also added the ability to sort by either ten point or insertion.      
 ;                                                                         
 ; 
 (DEFUN VTOL (ss dir insa / xposnam yposnam numm ent entt ten xpos ypos xx yy
                            pn maxx minx maxy miny xdif ydif poslst posnam
                                                       direct pos lastt order)
  (setq xposnam ())                      ; initialize (xpos & name list) list
  (setq yposnam ())                      ; initialize (ypos & name list) list
 ; Ŀ
 ;   Now see if the entities are arranged horizontally or vertically.      
 ; 
  (setq numm 0)                             ; start at the ss beginning again
  (while (setq ent (ssname ss numm))
         (setq entt (entget ent))
         (if (and insa (member (cdr (assoc 0 entt)) '("TEXT" "ATTDEF")))
             (setq ten (spit entt))
             (setq ten (cdr (assoc 10 entt))))
         (setq xpos (car ten))
         (setq ypos (cadr ten))
         (setq xx (append xx (list xpos)))  ; add x insert to list
         (setq yy (append yy (list ypos)))  ; and y to y list
 ; Ŀ
 ;   Also make the position and name list.  Have to make one for the X     
 ;   values and one for the Ys and use the appropriate one later.          
 ; 
         (setq pn (cons xpos ent))
         (setq xposnam (append xposnam (list pn)))
         (setq pn (cons ypos ent))
         (setq yposnam (append yposnam (list pn)))
         (setq numm (1+ numm)))             ; next entity
 ; Ŀ
 ;   Now evaluate the four lists.  The result will be the max and min      
 ;   values for the X and Y lists.                                         
 ; 
  (setq maxx (apply 'max xx))
  (setq minx (apply 'min xx))
  (setq maxy (apply 'max yy))
  (setq miny (apply 'min yy))
  (setq xdif (- maxx minx))
  (setq ydif (- maxy miny))
 ; Ŀ
 ;   Set direction variables to match whichever direction was given in     
 ;   the argument, if it was nil then deduce a direction.                  
 ; 
  (cond ((and (= (type dir) 'STR)
              (= (strcase dir) "X"))
          (setq poslst xx)                ; positions from X coord list
          (setq posnam xposnam)           ; position & ename list with X coord
          (setq direct 'min))             ; edit from smallest to largest X
        ((and (= (type dir) 'STR)
              (= (strcase dir) "Y"))
         (setq poslst yy)
         (setq posnam yposnam)
         (setq direct 'max))
        (T
 ; Ŀ
 ;   The default case: figure it out yourself.                             
 ;   Set vert to T if vertical, nil if horizontal.                         
 ;   If not sure, assume vertical.                                         
 ;   Could set strip to Quit and thus do so...                             
 ; 
         (cond ((> xdif ydif)             ; if (Xmax - Xmin) > (Ymax - Ymin)
                (setq poslst xx)          ; positions from X coord list
                (setq posnam xposnam)     ; position & ename list with X coord
                (setq direct 'min))       ; edit from smallest to largest X
               ((< xdif ydif)
                (setq poslst yy)
                (setq posnam yposnam)
                (setq direct 'max))
               (T                         ; if not sure then call it vertical
                (setq poslst yy)
                (setq posnam yposnam)
                (setq direct 'max)))))
 ; Ŀ
 ;   Now make the list of enames in order by increasing X or decreasing Y  
 ;   coordinate depending on whether the array is horizontal or vertical.  
 ;   Already Have Posnam: a list of (list position ename).                 
 ;   Using the original list of either x or y positions, get the first or  
 ;   last as appropriate, extract the ename from Posnam using              
 ;   (cdr (assoc (largest Y or smallest X) posnam))                        
 ;   and append the ename to the end of the enames in order list: Order.   
 ;   Then remove that position from the position list.                     
 ; 
  (while (> (length poslst) 0)
 ; Ŀ
 ;   Get the largest Y or smallest X value in the position list.           
 ; 
         (setq maxx (apply direct poslst))
 ; Ŀ
 ;   Having found Maxx, want to remove that value from poslst.             
 ;   Get the list from Maxx on, and the position of Maxx within the list.  
 ; 
         (setq pos (- (length poslst)
                      (length (setq lastt (member maxx poslst)))))
 ; Ŀ
 ;   Get the list after maxx.                                              
 ; 
         (setq lastt (cdr lastt))
 ; Ŀ
 ;   And add the list members before maxx.                                 
 ;   One could use (cdr (member (reverse poslist))) but if there were two  
 ;   values the same in the list this would result in a longer rather      
 ;   than a shorter poslist.                                               
 ; 
         (setq pos (1- pos))     ; subtract one: nth is zero based
         (while (>= pos 0)
                (setq lastt (append (list (nth pos poslst)) lastt))
                (setq pos (1- pos)))
         (setq poslst lastt)      ; poslst becomes lastt
 ; Ŀ
 ;   Now get the matching ename from posnam and add it to the end of the   
 ;   order list.                                                           
 ; 
         (setq order (append order (list (cdr (assoc maxx posnam)))))
 ; Ŀ
 ;   If there are two entities with the same position then assoc will      
 ;   always return the first one.  Must delete the first one each time -   
 ;   subst (nil) for it.                                                   
 ; 
         (setq posnam (subst (list nil) (assoc maxx posnam) posnam)))
 order)
 ; Ŀ
 ;   Vtol end.                                                             
 ; 

 ; Ŀ
 ;   Acc - ss (rather than sequential pick) ac.                            
 ; 
 (DEFUN C:ACC (/ blip enam enam2 taglst num)
  (setvar "cmdecho" 0)
  (command "undo" "be")
  (if (and (setq enam (car (entsel "Source block: ")))
           (assoc 66 (entget enam)))
      (progn
           (setq taglst (atlist enam))
           (v enam)))
  (setq num 0)
  (if (and taglst
           (write-line "\nDestination Blocks: ")
           (setq ss (ssget (list (cons 0 "insert") (cons 66 1)))))
      (while (setq enam2 (ssname ss num))
             (setq num (1+ num))
             (silt enam2 taglst)))
  (command "undo" "end")
 (princ))

 ; Ŀ
 ;   Sac - multiple Ac.                                                    
 ; 
 (DEFUN C:SAC (/ snapp *error* ss txlen orlstt posse ilen orlsti pos num
                             ssa source destin sortyp entt asoc1 destyp excess)
  (setvar "cmdecho" 0)
  (command "undo" "be")
  (setq snapp (getvar "snapmode"))
  (setvar "snapmode" 0)
 ; Ŀ
 ;   Make a local error handler.                                           
 ; 
  (defun *error* (shk)
   (if shk (write-line shk))
   (setvar "snapmode" snapp)
   (command "undo" "end")
  (princ))
 ; Ŀ
 ;   Get a selection set of inserts, count them.                           
 ; 
  (prompt "\nSource blocks: ")
  (setq ss (ssget '((-4 . "<and") (0 . "insert") (66 . 1) (-4 . "and>"))))
  (setq txlen (sslength ss))
 ; Ŀ
 ;   And get their enames as a list in vertical order.                     
 ; 
  (setq orlstt (vtol ss "" nil))
 ; Ŀ
 ;   Get a selection set of text or attribute-bearing blocks, count them.  
 ; 
  (prompt "\nDestination blocks: ")
  (setq ss (ssget '((-4 . "<and") (0 . "insert") (66 . 1) (-4 . "and>"))))
  (setq ilen (sslength ss))
 ; Ŀ
 ;   And get their enames as a list in vertical order.                     
 ; 
  (setq orlsti (vtol ss "" nil))
 ; Ŀ
 ;   Initialize the position in both selection set counters.               
 ; 
  (setq num 0)
 ; Ŀ
 ;   While there are source and destination entities, suck the former      
 ;   into the latter.                                                      
 ; 
  (while (and (setq source (nth num orlstt))
              (setq destin (nth num orlsti)))
         (setq taglst (atlist source))
         (v source)
         (silt destin taglst)
         (setq num (1+ num)))
 ; Ŀ
 ;   Sum up and warn the user of errors he has made.                       
 ; 
  (cond ((> ilen txlen)
         (setq excess (- ilen txlen))
         (prompt (strcat "\nCaution: " (itoa excess)
                         " Excess destination entit"
                         (if (= excess 1) "y." "ies."))))
        ((< ilen txlen)
         (setq excess (- txlen ilen))
         (prompt (strcat "\nCaution: " (itoa excess)
                         " Excess source entit"
                         (if (= excess 1) "y." "ies.")))))
 ; Ŀ
 ;   End.                                                                  
 ; 
  (*error* ())
 (princ))

 ; Ŀ
 ;   Ack - copy and kill.                                                  
 ; 
 (DEFUN C:ACK (/ blip enam enam2 taglst)
  (setvar "cmdecho" 0)
  (command "undo" "be")
  (setq blip (getvar "blipmode"))
  (setvar "blipmode" 0)
  (if (and (setq enam (car (entsel "Source block: ")))
           (assoc 66 (entget enam)))
      (progn
           (setq taglst (atlist enam))
           (v enam)))
  (if (and taglst
           (setq enam2 (car (entsel "\nTarget block: ")))
           (assoc 66 (entget enam2)))
      (progn
           (silt enam2 taglst)
           (entdel enam)))
  (setvar "blipmode" blip)
  (command "undo" "end")
 (princ))

 ; Ŀ
 ;   Ac - not the kind you make jelly out of.                              
 ; 
 (DEFUN C:AC (/ blip enam enam2 taglst)
  (setvar "cmdecho" 0)
  (command "undo" "be")
  (setq blip (getvar "blipmode"))
  (setvar "blipmode" 0)
  (if (and (setq enam (car (entsel "Source block: ")))
           (assoc 66 (entget enam)))
      (progn
           (setq taglst (atlist enam))
           (v enam)))
  (while (and taglst
              (setq enam2 (car (entsel "\nTarget block: ")))
              (assoc 66 (entget enam2)))
         (silt enam2 taglst))
  (setvar "blipmode" blip)
  (command "undo" "end")
 (princ))